﻿class CCrono
{
/*	:: Variables Miembro.
 */
	private var mdisplayTime:Number;	// Tiempo a viasualizar
	private var mlastTime:Number;		// Ultimo tiempo revisado
	private var mcurrentTime:Number;	// Tiempo Actual
	private var mauxTime:Number;		// Tiempo auxiliar
	
	private var mstarted:Boolean;	// Indica si el cronometro está iniciado
	private var mpaused:Boolean;	// Indica si el cronometro está pausado
	private var msuspended:Boolean;	// Suspende la actualización del display
	
	public function CCrono() {
		init();
	}
	
	private function init() {
		mlastTime 		= 0;
		mcurrentTime	= 0;
		mdisplayTime	= 0;
		
		mstarted	= false;
		mpaused		= false;
		msuspended	= false;
	}

/*	:: Funciones que controlan el cronometro.
 */
	public function startTime() {
		if(mstarted) {
			if(mpaused) pauseTime();
			if(msuspended) suspendTime();
		} else {
			mlastTime 		= getTimer();
			mcurrentTime	= 0;
			mdisplayTime	= 0;
			
			mstarted	= true;
			mpaused		= false;
			msuspended	= false;
		}
	}
	
	public function pauseTime() {
		if(!msuspended && mstarted) {
			if(mpaused)
				mlastTime = getTimer();
			else
				getTime();
			mpaused = !mpaused;
		}
	}
	public function suspendTime() {
		if(!mpaused && mstarted) {
			if(!msuspended)
				getTime();
			msuspended = !msuspended;
		}
	}
	
	public function stopTime() {
		mlastTime 		= 0;
		mcurrentTime	= 0;
		mdisplayTime	= 0;
		
		mstarted	= false;
		mpaused		= false;
		msuspended	= false;
	}

/*	:: Calculos. */
	private function getTime() {
		mauxTime = getTimer();
		mcurrentTime += mauxTime - mlastTime;
		mlastTime = mauxTime;
		if(!msuspended) mdisplayTime = mcurrentTime;
	}
	
/*	:: Devolución de datos. */
	public function get currentTime():Number {
		if(mstarted && !mpaused)
			getTime();
		return mcurrentTime;
	}
	
	public function get miliseconds():Number {
		return Math.floor(mdisplayTime / 10) % 100;
	}
	
	public function get seconds():Number {
		return Math.floor(mdisplayTime / 1000) % 60;
	}
	
	public function get minutes():Number {
		return Math.floor(mdisplayTime / 60000) % 60;
	}
	
	public function get hours():Number {
		return Math.floor(mdisplayTime / 3600000) % 24;
	}

/*	:: Estado del cronometro. */
	public function get started()	{ return mstarted; }
	public function get paused()	{ return mpaused; }
	public function get suspended()	{ return msuspended; }
}