/*
 * 
 * YCodaLazy plugin 2.0
 * $Date: 2008-05-18 13:22:09 +0200 (dom, 18 mag 2008) $
 * $Rev: 88 $
 * @requires jQuery v1.2.3
 * @requires YCodaSlider v2.0
 * 
 * Copyright (c) 2008 Massimiliano Balestrieri
 * Examples and docs at: http://maxb.net/blog/
 * Licensed GPL licenses:
 * http://www.gnu.org/licenses/gpl.html
 * 
 */

YCodaSlider.Lazy = {
    init    : function(selector, options){
        options = jQuery.extend({
                 type       : "img",
                 placeholder: false,
                 threshold  : 1,
                 effect     : "fadeIn",
                 effectspeed: "slow"
              }, options);
        
        var total = jQuery(selector).find(options.type).size();
        var current = location.hash && location.hash.slice(1) <= total ? 
                      (location.hash.slice(1) - 1) : 0;//mmmh
        //velocemente nascondi
        jQuery(selector).find(options.type).each(
            function(nr){
                if(!YCodaSlider.Lazy.is_near(nr, current, total, options.threshold)){
                    if(!jQuery(this).attr("original"))
                        jQuery(this).attr("original", jQuery(this).attr("src"));
                    //or : this.original = jQuery(this).attr("src") ?
                    if(options.placeholder){
                      jQuery(this).attr("src", options.placeholder).addClass("placeholder");
                    }else{
                      jQuery(this).removeAttr("src");
                    }
                }else{
                    if(jQuery(this).attr("src"))
                       this.loaded = true;
                }
            }
        ).end();

        //poi fai il resto
        jQuery(selector).each(
            function(nr){
                var self = this;//expando in ycodaslider element
                self.lazy = {};
                self.lazy.options = options;
                YCodaSlider.Lazy.lazyload(self, current, total);
            }
        );
    },
    lazyload : function(el, current, total){
        jQuery(el).find(el.lazy.options.type).each(
            function(nr){
                var that = this;//immagine
                //console.log(nr);
                //console.log(nr + " " +this.loaded + " " + $(this).attr("src") + " " + $(this).attr("original"));
                if(this.loaded && jQuery(this).attr("src") === el.lazy.options.placeholder) //fix bug sui frame?
                    this.loaded = false;
                    
                /* When appear is triggered load original image. */
                jQuery(that).one("appear", function() {
                    //console.log("appear");
                    if (!this.loaded) {
                        jQuery(this)
                           .hide()
                           .attr("src", jQuery(this).attr("original"))
                           .removeClass("placeholder")
                           [el.lazy.options.effect](el.lazy.options.effectspeed);
                        
                        this.loaded = true;
                    };
                });
                var flag = false;
                if(YCodaSlider.Lazy.is_near(nr, current, total, el.lazy.options.threshold)){   
                    if(!that.loaded){//se non è la prima chiamata triggero 
                        jQuery(that).trigger("appear");
                    }
                }
            }
        );
    },
    is_near  : function(nr, current, total, threshold){
        var tmax = current + threshold;
        var tmin = current - threshold;
        if(tmin < 0) tmin = 0; 
        if(tmax > total)  tmax = total;
        var left = !((current - threshold) >= 0);
        var right = (current + threshold) >= total;
        var flag3 = false;
        if(threshold === 0){
            return nr === current;
        }else{
            if(left || right)
                flag3 = YCodaSlider.Lazy.expr(nr, total, threshold, left, right); 
            return(
                nr === current ||                           //1 : current è uguale 
                (nr >= tmin && nr <= tmax) ||               //nr è compreso nella soglia?
                flag3
            );
        }
    },
    expr     : function(nr, total, threshold, left, right){
        if(left){
            return (nr >= (total - threshold) && nr <= total);// se siamo a sinistra
        }  
        if(right){
            return (nr >= 0 && nr <= threshold);// se siamo a sinistra
        }
    }
};
 