/*
 * 
 * YCodaSlider plugin 2.0
 * $Date: 2008-05-24 10:07:47 +0200 (sab, 24 mag 2008) $
 * $Rev: 121 $
 * @requires jQuery v1.2.3
 * @optional Easing v1.3
 * @optional History/Remote v0.2.3
 * @optional Dimensions 1.2
 * @optional UI core (rev.5607) + draggable (rev.5618)
 * 
 * Copyright (c) 2008 Massimiliano Balestrieri
 * Examples and docs at: http://maxb.net/blog/
 * Licensed GPL licenses:
 * http://www.gnu.org/licenses/gpl.html
 *
 * Based on Gian Carlo Mingati's slideViewer
 * http://www.gcmingati.net/wordpress/wp-content/lab/jquery/imagestrip/imageslide-plugin.html
 * Based on Niall Doherty's coda-slider
 * http://www.ndoherty.com/coda-slider  
 * Inspired by the clever folks at http://www.panic.com/coda
 */

if(!window.YCodaSlider)
    var YCodaSlider = {};

YCodaSlider.Base = {
    cnt       : 0,
    css       : function(url)
    {
        //solo alla prima istanza
        if(YCodaSlider.Base.cnt == 0)
           jQuery('head').append('<link type="text/css" href="'+url+'" rel="stylesheet" />'); 
    },
    build     : function(options)
    {
        
        options = jQuery.extend({
             height   :   false,
             shortcut :  [190,188],
             id       :   false,
             scroll   :   false,
             history  :   false,
             draggable:   false,
             sidebars :   true
              }, options);
        return this.each(
            function(nr)
            {
                //contatore statico di istanze
                YCodaSlider.Base.cnt++;

                this.ycodaslider = {};
                this.ycodaslider.options = options || {};
                    
                YCodaSlider.Base.gui(this, options);         
                YCodaSlider.Base.init(this);
                YCodaSlider.Base.count(this);
                YCodaSlider.Base.start(this);
                YCodaSlider.Base.nav(this);
                YCodaSlider.Base.bindings(this);
                YCodaSlider.Base.defaults(this);     
            }
        );
        
    },
    gui     :   function(el, options){
        el.id = el.ycodaslider.options.id || el.id || 'yslider-' + YCodaSlider.Base.cnt;//id
        var html = '<div class="yslider-wrap"><div class="yslider-viewer"><div class="yslider-container">';
        var jPanels = jQuery(".yslider-panelwrapper", el);
        jQuery(el).empty();
        jQuery(el)
        .append(html);
        jQuery('.yslider-container', el).append(jPanels);
        jPanels.wrap('<div class="yslider-panel">');
        
        if(!el.ycodaslider.options.sidebars)
            jQuery(".yslider-wrap", el).width(jQuery(".yslider-wrap", el).width() - 100);
    },
    count   :   function(el){
        var jContainer = jQuery("div.yslider-container",el);
        el.ycodaslider.pw = el.ycodaslider.options.width || jContainer.find("div.yslider-panel").width();
        el.ycodaslider.pc = jContainer.find("div.yslider-panel").size();//panel
        el.ycodaslider.vw = el.ycodaslider.pw * el.ycodaslider.pc;//viewer
        el.ycodaslider.nw = el.ycodaslider.pw;//el.ycodaslider.pc * 2 ?
        jContainer.css("width" , el.ycodaslider.vw);
    },
    init    :   function(el){
        if(el.ycodaslider.options.width){
            jQuery(el).css("width", el.ycodaslider.options.width + 100);
            jQuery('.yslider-panel,.yslider-viewer', el).css("width", el.ycodaslider.options.width);
        }
        if(el.ycodaslider.options.height)
            jQuery('.yslider-viewer', el).css("height", el.ycodaslider.options.height);
        if(el.ycodaslider.options.scroll)    
            jQuery('.yslider-viewer', el).css({"overflow-y":"auto"});
        if(el.ycodaslider.options.draggable){    
            jQuery('.yslider-container', el).draggable({axis : "x"}).hover(
                function(){
                    jQuery(this).css("cursor","move");
                },
                function(){
                    jQuery(this).css("cursor","");
                }
            );            
        }
    },
    start  :   function(el){
        // Specify the current panel.
        // If the loaded URL has a hash (cross-linking), we're going to use that hash to give the slider 
        // a specific starting position...
        if (YCodaSlider.Base.current(el)) {
            el.ycodaslider.current   = parseInt(location.hash.slice(1)) || 1;
            el.ycodaslider.cnt = - (el.ycodaslider.pw*(el.ycodaslider.current - 1));
            jQuery(el).find("div.yslider-container").css({ "left": el.ycodaslider.cnt });
        // Otherwise, we'll just set the current panel to 1...
        } else { 
            el.ycodaslider.current = 1;
        };
    },
    nav    :   function(el){
        var jViewer = jQuery("div.yslider-viewer",el);
        if(el.ycodaslider.options.sidebars){
            jViewer.before('<div class="yslider-navl"><a href="#">Left</a></div>');
            jViewer.after('<div class="yslider-navr"><a href="#">Right</a></div>');
        }
        jViewer.before('<div class="yslider-nav"><ul><\/ul></div>');
        
        var jNav = jQuery("div.yslider-nav ul",el);
        jQuery("div.yslider-panel",el)
        .each(function(n) {
            var lp = jQuery("div.yslider-panelwrapper",this).attr("title") || (n+1);
            if(el.ycodaslider.options.history){
                jQuery('<li><a href="#' + (n + 1) + '">' + lp + '</a></li>')
                .appendTo(jNav); 
            }else{
                jQuery('<li><a href="#">' + lp + '</a></li>')
                .appendTo(jNav)
                .click(function(){
                   return false;    
                });
            }
        });
        
        if(el.ycodaslider.options.width){
            jNav.parent().css("width" , el.ycodaslider.options.width);
        }else{
            jNav.parent().css("width" , el.ycodaslider.nw);
        } 
    },
    bindings : function(el){
                
        // Tab nav
        jQuery("div.yslider-nav a",el).each(function(z) {
            jQuery(this).bind("click", function() {
                jQuery(this)
                .addClass("current").parent().parent().find("a").not(jQuery(this))
                .removeClass("current"); // wow!
                //:) yes wow
                var cnt = - ( el.ycodaslider.pw * z);
                el.ycodaslider.current = z + 1;
                
                if(el.lazy)
                   YCodaSlider.Lazy.lazyload(el, (el.ycodaslider.current - 1), el.ycodaslider.pc);
                
                
                jQuery("div.yslider-container",el)
                .animate({ left: cnt } ,el.ycodaslider.options.easeTime,el.ycodaslider.options.easeFunc);
            });
        });
        // Left nav
        if(el.ycodaslider.options.sidebars)
        jQuery("div.yslider-navl a",el).click(function(){
            if (el.ycodaslider.current == 1) {
                var cnt = - (el.ycodaslider.pw * (el.ycodaslider.pc - 1));
                el.ycodaslider.current = el.ycodaslider.pc;
                jQuery(this).parent().parent().find("div.yslider-nav a.current")
                .removeClass("current").parent().parent().find("li:last a")
                .addClass("current");
            } else {
                el.ycodaslider.current -= 1;
                var cnt = - (el.ycodaslider.pw * (el.ycodaslider.current - 1));
                jQuery(this).parent().parent().find("div.yslider-nav a.current")
                .removeClass("current").parent().prev().find("a")
                .addClass("current");
            };
            if(el.lazy)
                YCodaSlider.Lazy.lazyload(el, (el.ycodaslider.current - 1), el.ycodaslider.pc);
                
            
            jQuery(this).parent().parent().find("div.yslider-container")
            .animate({ left: cnt } ,el.ycodaslider.options.easeTime,el.ycodaslider.options.easeFunc);
                    
            // Change the URL hash (cross-linking)...
            if(el.ycodaslider.options.history)
                location.hash = el.ycodaslider.current;
            return false;
        });
        
        // Right nav
        if(el.ycodaslider.options.sidebars)
        jQuery("div.yslider-navr a",el).click(function(){
            if (el.ycodaslider.current == el.ycodaslider.pc) {
                var cnt = 0;
                el.ycodaslider.current = 1;
                jQuery(this).parent().parent().find("div.yslider-nav a.current")
                .removeClass("current").parent().parent().find("a:eq(0)")
                .addClass("current");
            } else {
                var cnt = - (el.ycodaslider.pw * el.ycodaslider.current);
                el.ycodaslider.current += 1;
                jQuery(this).parent().parent().find("div.yslider-nav a.current")
                .removeClass("current").parent().next().find("a")
                .addClass("current");
            };
            
            if(el.lazy)
                YCodaSlider.Lazy.lazyload(el, (el.ycodaslider.current - 1), el.ycodaslider.pc);
            
            jQuery(this).parent().parent().find("div.yslider-container")
            .animate({ left: cnt } ,el.ycodaslider.options.easeTime,el.ycodaslider.options.easeFunc);
                    
            // Change the URL hash (cross-linking)...
            if(el.ycodaslider.options.history)
                location.hash = el.ycodaslider.current;
            return false;
        });
        //keycode
        var sc = el.ycodaslider.options.shortcut;
        if(sc && sc[0] && sc[1]){
            jQuery(document).keydown(function(e){
                if (e == null) { // ie
                    keycode = event.keyCode;
                } else { // mozilla
                    keycode = e.which;
                }
                //settabili - se non è nascosto muovi
                if(!(jQuery(el).css("display") === "none")){
                    if(keycode == sc[0]){ // display previous image
                       jQuery("div.yslider-navl a",el).trigger("click", el);
                    } else if(keycode == sc[1]){ // display next image
                       jQuery("div.yslider-navr a",el).trigger("click", el);
                    }  
                }
            });
        }
              
    },
    defaults    :   function(el){
        // Specify which tab is initially set to "current". 
        // Depends on if the loaded URL had a hash or not (cross-linking).
        if (YCodaSlider.Base.current(el)) {
            jQuery("div.yslider-nav a:eq(" + (location.hash.slice(1) - 1) + ")",el)
            .addClass("current");
        } else {
            //if(YCodaSlider.Base.init_current(el))//ok inizializzo 1. ma se non ho un'altra location
               //location.hash = 1;
               
            jQuery("div.yslider-nav a:eq(0)",el).addClass("current");
        }
    
    },
    current     :   function(el){
        return el.ycodaslider.options.history && 
               location.hash && 
               parseInt(location.hash.slice(1)) <= el.ycodaslider.pc;   
    }
};  
jQuery.fn.ycodaslider = YCodaSlider.Base.build;