﻿
/**
* ...
* @author Dani Llops
* @version 0.1
*/

package
{
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.text.TextField;
	import flash.utils.ByteArray;
	import com.adobe.images.JPGEncoder;
	import UploadPostHelper;
	
	
	public class Main extends MovieClip
	{	
		// MCs en el escenario
		public var foto_mc:Sprite;
		public var enviar_mc:Sprite;
		public var nombre_txt:TextField;
		public var edad_txt:TextField;
		public var ubicacion_txt:TextField;
		
		// Variables
		private var _ruta:String = "http://llops.com/blog/content/articulos/ene09/form2.php";
		private var _nombre_foto:String = "avatar.jpg";
		
		public function Main()
		{
			enviar_mc.buttonMode = true;
			enviar_mc.addEventListener(MouseEvent.CLICK, enviarFoto);
		}
		
		private function enviarFoto(e:MouseEvent):void 
		{		
			// Tomar un "pantallazo" de la foto
			var bmpData:BitmapData = new BitmapData(foto_mc.width, foto_mc.height);		// Crea un bitmapData con las dimensiones de la foto
			bmpData.draw(foto_mc);														// Dibuja la foto en bmpData
			
			// Codificar el bitmapData
			var jpg_codificado:JPGEncoder = new JPGEncoder(99);							// Crea un objeto JPGEncoder, con calidad 99
			var byteArray:ByteArray = jpg_codificado.encode(bmpData);					// Codifica el bitmapData en un ByteArray
			
			// Los datos de la ficha
			var datos:Object = new Object();
			datos.nombre = nombre_txt.text;
			datos.edad = edad_txt.text;
			datos.ubicacion = ubicacion_txt.text;
			
			// El objeto URLRequest contiene toda la información para el envío
			var urlFicha:URLRequest = new URLRequest();
			urlFicha.contentType = 'multipart/form-data; boundary=' + UploadPostHelper.getBoundary();
			urlFicha.requestHeaders.push( new URLRequestHeader( 'Cache-Control', 'no-cache' ) );
			urlFicha.method = URLRequestMethod.POST;
			urlFicha.data = UploadPostHelper.getPostData(_nombre_foto, byteArray, datos);	// Se crea el nuevo byteArray con toda la información
			urlFicha.url = _ruta;
			
			// Abre la dirección en una página en blanco para ver el resultado...
			navigateToURL(urlFicha, "_blank");
		}
	}
}