/*
 * Decompiled with CFR 0.152.
 */
package gmapimagecutter;

import gmapimagecutter.GMapImgCutApp;
import imagetoolscommon.ImageData;
import imagetoolscommon.ImageTileCutterThread;
import imagetoolscommon.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.imageio.IIOImage;
import javax.imageio.stream.FileImageOutputStream;

public class GMICCutterThread
extends ImageTileCutterThread {
    private boolean highQuality = true;
    private int apiVersion = 1;

    public ImageTileCutterThread copy() {
        GMICCutterThread thread = new GMICCutterThread();
        thread.highQuality = this.highQuality;
        thread.tileObserver = this.tileObserver;
        return thread;
    }

    public boolean isHighQuality() {
        return this.highQuality;
    }

    public void setHighQuality(boolean highQuality) {
        this.highQuality = highQuality;
    }

    public void setAPIVersion(int apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getTileDir() {
        return this.strTileDir;
    }

    public static void generateHTML(String templateHTML, String mainHTMLName, String createDir, String tileDir, int maxZoom) throws Exception {
        String line;
        String apiKeyTag = "<%APIKEY%>";
        String apiVersionTag = "<%APIVERSION%>";
        String mapTitleTag = "<%MAPTITLE%>";
        String maxZoomTag = "<%MAXZOOM%>";
        String maxZoomP1Tag = "<%MAXZOOMP1%>";
        String initialZoomTag = "<%INITIALZOOM%>";
        String centreLatTag = "<%CENTRELAT%>";
        String centreLonTag = "<%CENTRELON%>";
        String tileDirTag = "<%TILEDIR%>";
        double centreLat = 0.0;
        double centreLon = 0.0;
        int initialZoom = maxZoom >> 1;
        URL templateURL = GMapImgCutApp.class.getResource(templateHTML);
        BufferedReader reader = new BufferedReader(new InputStreamReader(templateURL.openStream()));
        BufferedWriter writer = new BufferedWriter(new FileWriter(createDir + "/" + mainHTMLName));
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("<%") >= 0) {
                line = line.replaceAll("<%APIKEY%>", "PUTAPIKEYHERE");
                line = line.replaceAll("<%APIVERSION%>", "2.x");
                line = line.replaceAll("<%MAPTITLE%>", "Picture Viewer");
                line = line.replaceAll("<%MAXZOOM%>", Integer.toString(maxZoom));
                line = line.replaceAll("<%MAXZOOMP1%>", Integer.toString(maxZoom + 1));
                line = line.replaceAll("<%INITIALZOOM%>", Integer.toString(initialZoom));
                line = line.replaceAll("<%CENTRELAT%>", Double.toString(centreLat));
                line = line.replaceAll("<%CENTRELON%>", Double.toString(centreLon));
                line = line.replaceAll("<%TILEDIR%>", tileDir);
            }
            writer.write(line);
            writer.newLine();
        }
        writer.close();
        reader.close();
    }

    private void makeTiles(int depth, double x, double y, double width, double height, String tileName) {
        if (this.abortCreate) {
            return;
        }
        if (depth <= 0) {
            return;
        }
        BufferedImage tileImg = new BufferedImage(256, 256, 1);
        Graphics2D g = tileImg.createGraphics();
        if (this.highQuality) {
            BufferedImage tmp = Utils.get256pxScaledInstance(this.originalImage, (int)x, (int)y, (int)(x + width), (int)(y + height));
            g.drawImage((Image)tmp, 0, 0, null);
        } else {
            g.drawImage(this.originalImage, 0, 0, 256, 256, (int)x, (int)y, (int)(x + width), (int)(y + height), Color.black, null);
        }
        g.dispose();
        try {
            ++this.currentTileCount;
            if (this.tileObserver != null) {
                this.tileObserver.processingTile(tileName + ".jpg", this.currentTileCount, this.totalTileCount);
            }
            this.imageWriter.setOutput(new FileImageOutputStream(new File(this.strTileDir + tileName + ".jpg")));
            IIOImage iioimage = new IIOImage(tileImg, null, null);
            this.imageWriter.write(null, iioimage, this.iwp);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        double centreX = x + width / 2.0;
        double centreY = y + height / 2.0;
        this.makeTiles(depth - 1, x, y, width / 2.0, height / 2.0, tileName + "q");
        this.makeTiles(depth - 1, centreX, y, width / 2.0, height / 2.0, tileName + "r");
        this.makeTiles(depth - 1, centreX, centreY, width / 2.0, height / 2.0, tileName + "s");
        this.makeTiles(depth - 1, x, centreY, width / 2.0, height / 2.0, tileName + "t");
    }

    public void setParams(ImageData imageData, int depth, boolean highQuality, int apiVersion) {
        this.tileObserver = null;
        this.createDepth = depth;
        this.highQuality = highQuality;
        this.apiVersion = apiVersion;
        this.totalTileCount = GMICCutterThread.calculateTotalTileCount(depth);
        this.originalImage = imageData.image;
        this.imageFilename = imageData.filename;
        this.strCreateDir = imageData.file.getParent();
        File tileDir = new File(imageData.file.getParentFile(), Utils.changeFileExt(this.imageFilename, "") + "-tiles");
        this.strTileDir = tileDir.getAbsolutePath() + File.separator;
    }

    public void setImageData(ImageData imageData) {
        super.setImageData(imageData);
        this.totalTileCount = GMICCutterThread.calculateTotalTileCount(this.createDepth);
    }

    public void beginCreate(int depth) {
        this.abortCreate = false;
        this.currentTileCount = 0;
        File tileDir = new File(this.strTileDir);
        tileDir.mkdirs();
        try {
            String htmlName = Utils.changeFileExt(this.imageFilename, ".html");
            String templateFilename = GMapImgCutApp.templateHTML[this.apiVersion];
            GMICCutterThread.generateHTML(templateFilename, htmlName, this.strCreateDir, tileDir.getName(), depth - 1);
        }
        catch (Exception ex) {
            Utils.showErrorDialogBox(null, "Error Generating HTML Page", null, ex);
            return;
        }
        this.setupImageWriter();
        double x = 0.0;
        double y = 0.0;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        if (width < height) {
            x = -(height - width) / 2;
            this.makeTiles(depth, x, y, height, height, "t");
        } else if (height < width) {
            y = -(width - height) / 2;
            this.makeTiles(depth, x, y, width, width, "t");
        } else {
            this.makeTiles(depth, x, y, width, height, "t");
        }
    }
}

