/*
 * Decompiled with CFR 0.152.
 */
package gmapimagecutter;

import gmapimagecutter.GMICCutterThread;
import gmapimagecutter.GMapImgCutApp;
import gmapimagecutter.TextTransfer;
import imagetoolscommon.AboutBox;
import imagetoolscommon.BatchCreateDialog;
import imagetoolscommon.CreateDialog;
import imagetoolscommon.ImageData;
import imagetoolscommon.ImageFileFilter;
import imagetoolscommon.ImagePanel;
import imagetoolscommon.Utils;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;

public class GMICMainFrame
extends JFrame {
    private DecimalFormat df = new DecimalFormat("0.######");
    private static final String windowText = "Create Image Tiles";
    private static final String highQualityText = "High Quality (slow)";
    private static final String lowQualityText = "Low Quality (fast)";
    private JFileChooser chooser = new JFileChooser();
    private ImageIcon mainIcon = new ImageIcon(GMICMainFrame.class.getResource("images/mainicon32.gif"));
    private ButtonGroup apiButtonGroup;
    private ImagePanel centrePanel;
    private JButton createButton;
    private JMenuItem createMenuItem;
    private JRadioButtonMenuItem gmapV2MenuItem;
    private JRadioButtonMenuItem gmapV3MenuItem;
    private JMenuItem helpAboutMenuItem;
    private JRadioButtonMenuItem highQualityMenuItem;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JSlider jSlider1;
    private JRadioButtonMenuItem lowQualityMenuItem;
    private ButtonGroup qualityButtonGroup;
    private JPanel rightPanel;
    private JLabel statusBar;
    private JLabel tileCountLabel;

    private void createButtonClick() {
        int depth = this.jSlider1.getValue();
        int apiVersion = 1;
        if (this.gmapV2MenuItem.isSelected()) {
            apiVersion = 0;
        }
        GMICCutterThread cutterThread = new GMICCutterThread();
        cutterThread.setParams(GMapImgCutApp.imageData, depth, this.highQualityMenuItem.isSelected(), apiVersion);
        CreateDialog cd = new CreateDialog((Frame)this, windowText, true, cutterThread);
        String text = windowText;
        text = cutterThread.isHighQuality() ? text + " - High Quality (slow)" : text + " - Low Quality (fast)";
        cd.setWindowText(text);
        cd.setVisible(true);
    }

    private String getLatLngText(double lat, double lon) {
        int apiVersion = 1;
        if (this.gmapV2MenuItem.isSelected()) {
            apiVersion = 0;
        }
        String text = "GLatLng(" + this.df.format(lat) + "," + this.df.format(lon) + ")";
        switch (apiVersion) {
            case 0: {
                text = "GLatLng(" + this.df.format(lat) + "," + this.df.format(lon) + ")";
                break;
            }
            case 1: {
                text = "google.maps.LatLng(" + this.df.format(lat) + "," + this.df.format(lon) + ")";
            }
        }
        return text;
    }

    public GMICMainFrame() {
        this.initComponents();
        Dimension dlgSize = this.getSize();
        Dimension frmSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point loc = this.getLocation();
        this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    }

    private void initComponents() {
        this.qualityButtonGroup = new ButtonGroup();
        this.apiButtonGroup = new ButtonGroup();
        this.rightPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel2 = new JLabel();
        this.tileCountLabel = new JLabel();
        this.createButton = new JButton();
        this.statusBar = new JLabel();
        this.centrePanel = new ImagePanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItem2 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.lowQualityMenuItem = new JRadioButtonMenuItem();
        this.highQualityMenuItem = new JRadioButtonMenuItem();
        this.jSeparator1 = new JSeparator();
        this.gmapV2MenuItem = new JRadioButtonMenuItem();
        this.gmapV3MenuItem = new JRadioButtonMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.createMenuItem = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.helpAboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Image Cutter");
        this.setIconImage(this.mainIcon.getImage());
        this.jLabel1.setText("Max Zoom Level");
        this.jLabel1.setEnabled(false);
        this.jSlider1.setMajorTickSpacing(5);
        this.jSlider1.setMaximum(17);
        this.jSlider1.setMinorTickSpacing(1);
        this.jSlider1.setOrientation(1);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setEnabled(false);
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GMICMainFrame.this.jSlider1StateChanged(evt);
            }
        });
        this.jLabel2.setText("Tile Count:");
        this.jLabel2.setEnabled(false);
        this.tileCountLabel.setText("0");
        this.tileCountLabel.setEnabled(false);
        this.createButton.setText("Create...");
        this.createButton.setEnabled(false);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GMICMainFrame.this.createButtonActionPerformed(evt);
            }
        });
        GroupLayout rightPanelLayout = new GroupLayout(this.rightPanel);
        this.rightPanel.setLayout(rightPanelLayout);
        rightPanelLayout.setHorizontalGroup(rightPanelLayout.createParallelGroup(1).add(rightPanelLayout.createSequentialGroup().addContainerGap().add(rightPanelLayout.createParallelGroup(1).add(this.jLabel1, -1, 111, Short.MAX_VALUE).add(this.createButton))).add(rightPanelLayout.createSequentialGroup().addContainerGap().add(this.jLabel2).addPreferredGap(0).add(this.tileCountLabel, -1, 14, Short.MAX_VALUE).add(20, 20, 20)).add(rightPanelLayout.createSequentialGroup().add(30, 30, 30).add(this.jSlider1, -2, 52, -2).addContainerGap(49, Short.MAX_VALUE)));
        rightPanelLayout.setVerticalGroup(rightPanelLayout.createParallelGroup(1).add(rightPanelLayout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.jSlider1, -1, 216, Short.MAX_VALUE).addPreferredGap(0).add(rightPanelLayout.createParallelGroup(3).add(this.jLabel2).add(this.tileCountLabel)).addPreferredGap(0).add(this.createButton).addContainerGap()));
        this.centrePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GMICMainFrame.this.centrePanelMouseClicked(evt);
            }
        });
        this.centrePanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                GMICMainFrame.this.centrePanelMouseMoved(evt);
            }
        });
        GroupLayout centrePanelLayout = new GroupLayout(this.centrePanel);
        this.centrePanel.setLayout(centrePanelLayout);
        centrePanelLayout.setHorizontalGroup(centrePanelLayout.createParallelGroup(1).add(0, 366, Short.MAX_VALUE));
        centrePanelLayout.setVerticalGroup(centrePanelLayout.createParallelGroup(1).add(0, 309, Short.MAX_VALUE));
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("Open File...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GMICMainFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem3.setText("Batch Process...");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GMICMainFrame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenu1.add(this.jSeparator2);
        this.jMenuItem2.setText("Exit");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GMICMainFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Processing");
        this.qualityButtonGroup.add(this.lowQualityMenuItem);
        this.lowQualityMenuItem.setText("Low Quality Images");
        this.jMenu2.add(this.lowQualityMenuItem);
        this.qualityButtonGroup.add(this.highQualityMenuItem);
        this.highQualityMenuItem.setSelected(true);
        this.highQualityMenuItem.setText("High Quality Images");
        this.jMenu2.add(this.highQualityMenuItem);
        this.jMenu2.add(this.jSeparator1);
        this.apiButtonGroup.add(this.gmapV2MenuItem);
        this.gmapV2MenuItem.setText("GMap API v2");
        this.jMenu2.add(this.gmapV2MenuItem);
        this.apiButtonGroup.add(this.gmapV3MenuItem);
        this.gmapV3MenuItem.setSelected(true);
        this.gmapV3MenuItem.setText("GMap API v3");
        this.jMenu2.add(this.gmapV3MenuItem);
        this.jMenu2.add(this.jSeparator3);
        this.createMenuItem.setText("Create...");
        this.createMenuItem.setEnabled(false);
        this.createMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GMICMainFrame.this.createMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.createMenuItem);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("Help");
        this.helpAboutMenuItem.setText("About");
        this.helpAboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GMICMainFrame.this.helpAboutMenuItemActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.helpAboutMenuItem);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.centrePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(this.rightPanel, -2, -1, -2)).add(this.statusBar, -1, 497, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(2).add(this.centrePanel, -1, -1, Short.MAX_VALUE).add(this.rightPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(this.statusBar)));
        this.pack();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        GMICCutterThread cutterThread = new GMICCutterThread();
        cutterThread.setHighQuality(this.highQualityMenuItem.isSelected());
        BatchCreateDialog bd = new BatchCreateDialog((Frame)this, true, cutterThread);
        bd.setVisible(true);
    }

    private void createMenuItemActionPerformed(ActionEvent evt) {
        this.createButtonClick();
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        this.createButtonClick();
    }

    private void centrePanelMouseMoved(MouseEvent evt) {
        Rectangle rect = this.centrePanel.getSquareImageRectangle();
        if (rect != null) {
            String text = GMapImgCutApp.imageData.filename + " " + GMapImgCutApp.imageData.image.getWidth() + " x " + GMapImgCutApp.imageData.image.getHeight() + " pixels";
            int x = evt.getX() - rect.x;
            int y = evt.getY() - rect.y;
            if (x >= 0 && x <= rect.width && y >= 0 && y <= rect.height) {
                double mx = ((double)x / (double)rect.width - 0.5) * 360.0;
                double my = (0.5 - (double)y / (double)rect.height) * 360.0;
                Point2D.Double lonlat = Utils.mercatorXYToLonLat(mx, my);
                text = text + ", " + this.getLatLngText(lonlat.y, lonlat.x);
            }
            this.statusBar.setText(text);
        }
    }

    private void centrePanelMouseClicked(MouseEvent evt) {
        Rectangle rect = this.centrePanel.getSquareImageRectangle();
        if (rect == null) {
            return;
        }
        int x = evt.getX() - rect.x;
        int y = evt.getY() - rect.y;
        if (x >= 0 && x <= rect.width && y >= 0 && y <= rect.height) {
            double mx = ((double)x / (double)rect.width - 0.5) * 360.0;
            double my = (0.5 - (double)y / (double)rect.height) * 360.0;
            Point2D.Double lonlat = Utils.mercatorXYToLonLat(mx, my);
            String text = this.getLatLngText(lonlat.y, lonlat.x);
            TextTransfer textTransfer = new TextTransfer();
            textTransfer.setClipboardContents(text);
        }
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        int count = GMICCutterThread.calculateTotalTileCount(this.jSlider1.getValue());
        this.tileCountLabel.setText(Integer.toString(count));
    }

    private void helpAboutMenuItemActionPerformed(ActionEvent evt) {
        ImageIcon image = new ImageIcon(GMICMainFrame.class.getResource("images/mainicon32.gif"));
        String title = "GMap Image Cutter";
        String copyright = "Created by the Centre for Advanced Spatial Analysis at UCL";
        String version = "Version: 1.43";
        String comments = "The Google Maps Image Cutter takes an image file (gif, jpeg, png or tiff) and automatically creates a working Google Maps site or a Photo Overlay for Google Earth. The initial zoom level on loading an image is calculated to match the image resolution, so the max zoom level slider will not normally need to be altered. The status bar at the bottom of the window shows the image name and dimensions together with the point in the image that the mouse is currently over. This point is in lat/lon coordinates to allow markers to be added to the resulting Google Map by editing the html. See the readme file for more information.";
        AboutBox aboutBox = new AboutBox(this, true, image, "GMap Image Cutter", "Version: 1.43", "Created by the Centre for Advanced Spatial Analysis at UCL", "The Google Maps Image Cutter takes an image file (gif, jpeg, png or tiff) and automatically creates a working Google Maps site or a Photo Overlay for Google Earth. The initial zoom level on loading an image is calculated to match the image resolution, so the max zoom level slider will not normally need to be altered. The status bar at the bottom of the window shows the image name and dimensions together with the point in the image that the mouse is currently over. This point is in lat/lon coordinates to allow markers to be added to the resulting Google Map by editing the html. See the readme file for more information.");
        aboutBox.setVisible(true);
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.dispose();
        System.exit(0);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.chooser.setAcceptAllFileFilterUsed(true);
        this.chooser.setFileFilter(new ImageFileFilter());
        this.chooser.setMultiSelectionEnabled(false);
        if (this.chooser.showOpenDialog(this) == 0) {
            try {
                GMapImgCutApp.imageData = ImageData.loadFile(this.chooser.getSelectedFile());
                if (GMapImgCutApp.imageData.image == null) {
                    Utils.showErrorDialogBox(this, "Error Loading Image", "The file " + this.chooser.getSelectedFile().getName() + " could not be loaded for some reason. Please ensure" + " that this file type can be handled by ImageIO and" + " install Java Advanced Imaging or any required image" + " reader extensions. See the readme file for more" + " information.", null);
                    return;
                }
                this.jSlider1.setValue(GMICCutterThread.calculateMaxZoomDepth(GMapImgCutApp.imageData.image.getWidth(), GMapImgCutApp.imageData.image.getHeight()));
                this.centrePanel.setImage(GMapImgCutApp.imageData.image);
                this.statusBar.setText(this.chooser.getSelectedFile().getName() + " " + GMapImgCutApp.imageData.image.getWidth() + " x " + GMapImgCutApp.imageData.image.getHeight() + " pixels");
                this.jLabel2.setEnabled(true);
                this.createMenuItem.setEnabled(true);
                this.jSlider1.setEnabled(true);
                this.createButton.setEnabled(true);
                this.jLabel1.setEnabled(true);
                this.tileCountLabel.setEnabled(true);
                this.centrePanel.repaint();
            }
            catch (Exception ex) {
                Utils.showErrorDialogBox(this, "Error loading image file", "Error loading image file " + this.chooser.getSelectedFile().getAbsolutePath(), ex);
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new GMICMainFrame().setVisible(true);
            }
        });
    }
}

