/*
 * Decompiled with CFR 0.152.
 */
package gmapimagecutter;

import gmapimagecutter.GMICCutterThread;
import imagetoolscommon.ImageData;
import imagetoolscommon.TileObserver;
import imagetoolscommon.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;

public class GMICUtils {
    public static BufferedImage makeSingleTile(BufferedImage originalImage, boolean highQuality, String tileString, int zoomLevel, double x, double y, double width, double height) {
        if (zoomLevel >= tileString.length()) {
            BufferedImage tileImg = new BufferedImage(256, 256, 1);
            Graphics2D g = tileImg.createGraphics();
            g.setPaint(Color.BLACK);
            g.fillRect(0, 0, 256, 256);
            if (highQuality) {
                BufferedImage tmp = Utils.get256pxScaledInstance(originalImage, (int)x, (int)y, (int)(x + width), (int)(y + height));
                g.drawImage((Image)tmp, 0, 0, null);
            } else {
                g.drawImage(originalImage, 0, 0, 256, 256, (int)x, (int)y, (int)(x + width), (int)(y + height), Color.black, null);
            }
            return tileImg;
        }
        double centreX = x + width / 2.0;
        double centreY = y + height / 2.0;
        switch (tileString.charAt(zoomLevel)) {
            case 'q': {
                return GMICUtils.makeSingleTile(originalImage, highQuality, tileString, zoomLevel + 1, x, y, width / 2.0, height / 2.0);
            }
            case 'r': {
                return GMICUtils.makeSingleTile(originalImage, highQuality, tileString, zoomLevel + 1, centreX, y, width / 2.0, height / 2.0);
            }
            case 's': {
                return GMICUtils.makeSingleTile(originalImage, highQuality, tileString, zoomLevel + 1, centreX, centreY, width / 2.0, height / 2.0);
            }
            case 't': {
                return GMICUtils.makeSingleTile(originalImage, highQuality, tileString, zoomLevel + 1, x, centreY, width / 2.0, height / 2.0);
            }
        }
        return null;
    }

    public static void loadAndCreate(String filename, boolean isHighRes, int apiVersion, int maxZoom) throws Exception {
        File fullpath = new File(filename).getCanonicalFile();
        ImageData imageData = ImageData.loadFile(fullpath);
        System.out.println("Loaded image file " + filename);
        if (maxZoom <= 0) {
            maxZoom = GMICCutterThread.calculateMaxZoomDepth(imageData.image.getWidth(), imageData.image.getHeight());
        }
        GMICCutterThread cutterThread = new GMICCutterThread();
        cutterThread.setParams(imageData, maxZoom, isHighRes, apiVersion);
        class CountTiles
        implements TileObserver {
            public int totalCount = 0;
            public int currentCount = 0;
            public boolean finishedCount = false;

            CountTiles() {
            }

            public void processingTile(String filename, int count, int totalCount) {
                this.currentCount = count;
                this.totalCount = totalCount;
            }

            public void finishedProcessingTiles(int totalCount) {
                this.totalCount = totalCount;
                this.finishedCount = true;
            }
        }
        CountTiles counter = new CountTiles();
        cutterThread.setTileObserver(counter);
        int count = GMICCutterThread.calculateTotalTileCount(maxZoom);
        System.out.println("Creating " + count + " tiles (maxzoom=" + maxZoom + ") in " + cutterThread.getTileDir());
        long startTime = System.currentTimeMillis();
        cutterThread.beginCreate(maxZoom);
        while (cutterThread.isRunning()) {
            Thread.yield();
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        System.out.println(counter.currentCount + " tiles created out of " + counter.totalCount + " in " + elapsedTime / 1000L + " seconds");
    }
}

