/*
 * Decompiled with CFR 0.152.
 */
package gmapimagecutter;

import gmapimagecutter.GMICMainFrame;
import gmapimagecutter.GMICUtils;
import imagetoolscommon.ImageData;
import imagetoolscommon.Utils;
import java.awt.EventQueue;
import javax.swing.UIManager;

public class GMapImgCutApp {
    public static final String appName = "GMap Image Cutter";
    public static final String appVersion = "1.43";
    public static ImageData imageData;
    public static final int apiGMap2 = 0;
    public static final int apiGMap3 = 1;
    public static final String[] templateHTML;

    public static void main(String[] args) {
        if (args.length > 0) {
            GMapImgCutApp.doCommandLine(args);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception ex) {
                    Utils.showErrorDialogBox(null, "Exception setting look and feel", "", ex);
                }
                new GMICMainFrame().setVisible(true);
            }
        });
    }

    private static void doCommandLine(String[] args) {
        String filename = "";
        boolean hires = true;
        int apiVersion = 1;
        int maxzoom = -1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-f")) {
                if (args[i].length() > 2) {
                    filename = args[i].substring(2);
                    continue;
                }
                filename = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-hires")) {
                hires = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-lowres")) {
                hires = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-v2")) {
                apiVersion = 0;
                continue;
            }
            if (args[1].equalsIgnoreCase("-v3")) {
                apiVersion = 1;
                continue;
            }
            if (!args[i].startsWith("-z")) continue;
            maxzoom = args[i].length() > 2 ? Integer.parseInt(args[i].substring(2)) : Integer.parseInt(args[++i]);
        }
        if (filename.length() > 0) {
            System.out.println("Command line mode: input file=" + filename);
            try {
                GMICUtils.loadAndCreate(filename, hires, apiVersion, maxzoom);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("Usage is:");
            System.out.println("-f [Input Filename]");
            System.out.println("-hires\tSet high resolution image output (default)");
            System.out.println("-lowres\tSet low resolution image output");
            System.out.println("-v2\tSet api to Google Maps v2");
            System.out.println("-v3\tSet api to Google Maps v3 (default)");
            System.out.println("-z[nn]\tOverride automatic max zoom level with number following -z");
            System.out.println();
            System.out.println("Example:");
            System.out.println("java -Xms1024M -Xmx1024M -jar gmapimagecutter.jar -fmyimage.png");
            System.out.println();
            System.out.println("This loads myimage.png and creates it in hi-res mode with automatic zoom level depth calculation");
            System.out.println();
        }
    }

    static {
        templateHTML = new String[]{"templatefiles/template.html", "templatefiles/templatev3.html"};
    }
}

