/*
 * Decompiled with CFR 0.152.
 */
package imagetoolscommon;

import imagetoolscommon.CreateDialog_cancelButton_actionAdapter;
import imagetoolscommon.CreateDialog_startButton_actionAdapter;
import imagetoolscommon.ImageTileCutterThread;
import imagetoolscommon.TileObserver;
import imagetoolscommon.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class CreateDialog
extends JDialog
implements TileObserver {
    private ImageTileCutterThread createThread;
    JPanel progressPanel = new JPanel();
    JProgressBar jProgressBar1 = new JProgressBar();
    JButton startButton = new JButton();
    JButton cancelButton = new JButton();
    JLabel jLabel1 = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel textPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();

    public CreateDialog(Frame owner, String title, boolean modal, ImageTileCutterThread createThread) {
        super(owner, title, modal);
        try {
            this.createThread = createThread;
            createThread.setTileObserver(this);
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.updateDescriptiveText();
            this.pack();
            this.setSize(320, 120);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setWindowText(String text) {
        this.setTitle(text);
    }

    private void jbInit() throws Exception {
        this.startButton.setText("Start");
        this.startButton.addActionListener(new CreateDialog_startButton_actionAdapter(this));
        this.cancelButton.setEnabled(true);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new CreateDialog_cancelButton_actionAdapter(this));
        this.jLabel1.setText("jLabel1");
        this.getContentPane().setLayout(this.borderLayout1);
        this.progressPanel.setLayout(this.borderLayout2);
        this.jProgressBar1.setMinimumSize(new Dimension(128, 18));
        this.jProgressBar1.setStringPainted(true);
        this.setResizable(false);
        this.borderLayout1.setHgap(4);
        this.borderLayout1.setVgap(4);
        this.progressPanel.setMinimumSize(new Dimension(256, 18));
        this.buttonPanel.setMinimumSize(new Dimension(256, 33));
        this.textPanel.setMinimumSize(new Dimension(256, 25));
        this.textPanel.setLayout(this.flowLayout1);
        this.buttonPanel.add(this.startButton);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.progressPanel, "Center");
        this.getContentPane().add((Component)this.textPanel, "North");
        this.progressPanel.add((Component)this.jProgressBar1, "South");
        this.textPanel.add((Component)this.jLabel1, null);
    }

    private void updateDescriptiveText() {
        String createDir = this.createThread.strCreateDir;
        int tileCount = this.createThread.totalTileCount;
        String text = createDir;
        if (text.length() > 30) {
            text = text.substring(0, 30) + "...";
        }
        this.jLabel1.setToolTipText(createDir);
        this.jLabel1.setText(tileCount + " files will be created in: " + text);
    }

    public void processingTile(String filename, int count, int totalCount) {
        this.jLabel1.setText("Tile: " + filename);
        if (count > 0) {
            int percent = count * 100 / totalCount;
            this.jProgressBar1.setValue(percent);
            this.jProgressBar1.setString(Integer.toString(percent) + "%");
        }
    }

    public void finishedProcessingTiles(int totalCount) {
        this.jProgressBar1.setValue(100);
        this.jProgressBar1.setString("100%");
        this.jLabel1.setText("Successfully created " + totalCount + " tiles");
        this.cancelButton.setText("Finish");
    }

    public void doTileCreation() {
        this.cancelButton.setEnabled(true);
        this.startButton.setEnabled(false);
        try {
            this.createThread.start();
        }
        catch (Exception ex) {
            this.createThread.abortCreate();
            this.jLabel1.setText("Create aborted.");
            Utils.showErrorDialogBox(this, "Error Creating Tiles", null, ex);
        }
    }

    public void startButton_actionPerformed(ActionEvent e) {
        this.doTileCreation();
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.createThread.abortCreate();
        this.jLabel1.setText("Create aborted.");
        this.setVisible(false);
        this.dispose();
    }
}

