/*
 * Decompiled with CFR 0.152.
 */
package imagetoolscommon;

import imagetoolscommon.Utils;
import java.io.File;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;

public class ImageFileFilter
extends FileFilter {
    public static String imageFileExts;
    public static String imageFilesDescription;

    public ImageFileFilter() {
        ImageFileFilter.initFileFormats();
    }

    public static void initFileFormats() {
        HashSet<String> hash = new HashSet<String>();
        String[] names = ImageIO.getReaderFormatNames();
        for (int i = 0; i < names.length; ++i) {
            hash.add(names[i]);
        }
        imageFileExts = "";
        imageFilesDescription = " ";
        if (hash.contains("jpeg") || hash.contains("jpg")) {
            imageFileExts = imageFileExts + ".jpg.jpeg";
            imageFilesDescription = imageFilesDescription + ".jpg .jpeg ";
        }
        if (hash.contains("gif")) {
            imageFileExts = imageFileExts + ".gif";
            imageFilesDescription = imageFilesDescription + ".gif ";
        }
        if (hash.contains("png")) {
            imageFileExts = imageFileExts + ".png";
            imageFilesDescription = imageFilesDescription + ".png ";
        }
        if (hash.contains("tif") || hash.contains("tiff")) {
            imageFileExts = imageFileExts + ".tif.tiff";
            imageFilesDescription = imageFilesDescription + ".tif .tiff ";
        }
        if (hash.contains("bmp")) {
            imageFileExts = imageFileExts + ".bmp";
            imageFilesDescription = imageFilesDescription + ".bmp ";
        }
        if (hash.contains("raw")) {
            imageFileExts = imageFileExts + ".raw";
            imageFilesDescription = imageFilesDescription + ".raw ";
        }
        if (hash.contains("pnm")) {
            imageFileExts = imageFileExts + ".pnm";
            imageFilesDescription = imageFilesDescription + ".pnm ";
        }
    }

    public boolean accept(File f) {
        String ext = Utils.getFileExtension(f.getName());
        if (ext == null) {
            return f.isDirectory();
        }
        ext = ext.toLowerCase();
        return f.isDirectory() || imageFileExts.indexOf(ext) >= 0;
    }

    public String getDescription() {
        return "Image Files (" + imageFilesDescription + ")";
    }
}

