/*
 * Decompiled with CFR 0.152.
 */
package imagetoolscommon;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class ImagePanel
extends JComponent {
    private Image image;
    private int width;
    private int height;
    private Rectangle imageRect;

    public ImagePanel() {
    }

    public Rectangle getImageRectangle() {
        return this.imageRect;
    }

    public Rectangle getSquareImageRectangle() {
        if (this.imageRect == null) {
            return null;
        }
        Rectangle rect = null;
        if (this.imageRect.width > this.imageRect.height) {
            int size = this.imageRect.width;
            rect = new Rectangle(this.imageRect.x, this.imageRect.y - (this.imageRect.width - this.imageRect.height) / 2, size, size);
        } else {
            int size = this.imageRect.height;
            rect = new Rectangle(this.imageRect.x - (this.imageRect.height - this.imageRect.width) / 2, this.imageRect.y, size, size);
        }
        return rect;
    }

    public ImagePanel(Image image) {
        this.setImage(image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        if (image == null) {
            return;
        }
        this.width = image.getWidth(this);
        if (this.width <= 0) {
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(image, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.width = image.getWidth(this);
        }
        this.height = image.getHeight(this);
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    public void paintComponent(Graphics g) {
        if (this.image != null) {
            float imageAspect = (float)this.width / (float)this.height;
            float screenAspect = (float)this.getWidth() / (float)this.getHeight();
            if (imageAspect > screenAspect) {
                int h = (int)((float)this.getWidth() / imageAspect);
                int offY = (this.getHeight() - h) / 2;
                this.imageRect = new Rectangle(0, offY, this.getWidth(), h);
                g.drawImage(this.image, 0, offY, this.getWidth(), h, this);
            } else {
                int w = (int)((float)this.getHeight() * imageAspect);
                int offX = (this.getWidth() - w) / 2;
                this.imageRect = new Rectangle(offX, 0, w, this.getHeight());
                g.drawImage(this.image, offX, 0, w, this.getHeight(), this);
            }
        } else {
            g.setColor(Color.black);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fm = g.getFontMetrics();
            g.setColor(Color.white);
            String text = "No Image Loaded";
            g.drawString(text, (this.getWidth() - fm.stringWidth(text)) / 2, this.getHeight() / 2);
        }
    }
}

