/*
 * Decompiled with CFR 0.152.
 */
package imagetoolscommon;

import imagetoolscommon.ImageData;
import imagetoolscommon.TileObserver;
import imagetoolscommon.Utils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;

public abstract class ImageTileCutterThread
extends Thread {
    protected TileObserver tileObserver;
    protected int currentTileCount = 0;
    protected int totalTileCount = 0;
    protected String currentFilename;
    protected ImageWriter imageWriter;
    protected ImageWriteParam iwp;
    protected BufferedImage originalImage;
    protected int createDepth;
    protected String imageFilename;
    protected String strCreateDir;
    protected String strTileDir;
    protected boolean running = false;
    protected boolean abortCreate = false;

    public abstract ImageTileCutterThread copy();

    public int getCurrentTileCount() {
        return this.currentTileCount;
    }

    public int getTotalTileCount() {
        return this.totalTileCount;
    }

    public void setTileObserver(TileObserver tileObserver) {
        this.tileObserver = tileObserver;
    }

    public void setImageData(ImageData imageData) {
        int depth;
        this.originalImage = imageData.image;
        this.imageFilename = imageData.filename;
        this.strCreateDir = imageData.file.getParent();
        File tileDir = new File(this.strCreateDir, Utils.changeFileExt(this.imageFilename, "") + "-tiles");
        this.strTileDir = tileDir.getAbsolutePath() + File.separator;
        this.createDepth = depth = ImageTileCutterThread.calculateMaxZoomDepth(this.originalImage.getWidth(), this.originalImage.getHeight());
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        this.running = true;
        this.currentTileCount = 0;
        this.currentFilename = "Initialising...";
        this.beginCreate(this.createDepth);
        if (!this.abortCreate) {
            this.totalTileCount = this.currentTileCount;
        }
        if (this.tileObserver != null) {
            this.tileObserver.finishedProcessingTiles(this.totalTileCount);
        }
        this.running = false;
    }

    public static int calculateMaxZoomDepth(int width, int height) {
        double d = Math.max(width, height);
        double z = Math.log(d / 256.0) / Math.log(2.0);
        int depth = (int)Math.ceil(z + 1.0);
        return depth;
    }

    public static int calculateTotalTileCount(int depth) {
        int count = 0;
        for (int i = 0; i < depth; ++i) {
            count = (int)((double)count + Math.pow(4.0, i));
        }
        return count;
    }

    public void abortCreate() {
        this.abortCreate = true;
    }

    protected void setupImageWriter() {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("JPG");
        if (iter.hasNext()) {
            this.imageWriter = iter.next();
            this.iwp = this.imageWriter.getDefaultWriteParam();
            this.iwp.setCompressionMode(2);
        }
    }

    public abstract void beginCreate(int var1);
}

