/*
 * Decompiled with CFR 0.152.
 */
package imagetoolscommon;

import imagetoolscommon.ImageTileCutterThread;
import imagetoolscommon.TileObserver;
import imagetoolscommon.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class NBCreateDialog
extends JDialog
implements TileObserver {
    private ImageTileCutterThread createThread;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JProgressBar jProgressBar1;
    private JPanel progressPanel;
    private JButton startButton;
    private JPanel textPanel;

    public NBCreateDialog(Frame parent, String title, boolean modal, ImageTileCutterThread createThread) {
        super(parent, title, modal);
        this.createThread = createThread;
        createThread.setTileObserver(this);
        this.initComponents();
        this.updateDescriptiveText();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void setWindowText(String text) {
        this.setTitle(text);
    }

    private void updateDescriptiveText() {
        String createDir = this.createThread.strCreateDir;
        int tileCount = this.createThread.totalTileCount;
        String text = createDir;
        String message = tileCount + " files will be created in: ";
        FontMetrics fm = this.getFontMetrics(this.jLabel1.getFont());
        int msgWidth = fm.stringWidth(message);
        while (text.length() > 0) {
            if (fm.stringWidth(text) >= 1 - msgWidth) break;
            text = text.substring(0, text.length() - 1);
        }
        if (text.length() < createDir.length()) {
            text = text + "...";
        }
        this.jLabel1.setToolTipText(createDir);
        this.jLabel1.setText(message + text);
    }

    public void processingTile(String filename, int count, int totalCount) {
        this.jLabel1.setText("Tile: " + filename);
        if (count > 0) {
            int percent = count * 100 / totalCount;
            this.jProgressBar1.setValue(percent);
            this.jProgressBar1.setString(Integer.toString(percent) + "%");
        }
    }

    public void finishedProcessingTiles(int totalCount) {
        this.jProgressBar1.setValue(100);
        this.jProgressBar1.setString("100%");
        this.jLabel1.setText("Successfully created " + totalCount + " tiles");
        this.cancelButton.setText("Finish");
    }

    public void doTileCreation() {
        this.cancelButton.setEnabled(true);
        this.startButton.setEnabled(false);
        try {
            this.createThread.start();
        }
        catch (Exception ex) {
            this.createThread.abortCreate();
            this.jLabel1.setText("Create aborted.");
            Utils.showErrorDialogBox(this, "Error Creating Tiles", null, ex);
        }
    }

    private void initComponents() {
        this.textPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.progressPanel = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new BorderLayout(4, 4));
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(320, 120));
        this.setResizable(false);
        this.jLabel1.setText("jLabel1");
        this.textPanel.add(this.jLabel1);
        this.getContentPane().add((Component)this.textPanel, "North");
        this.progressPanel.setLayout(new BorderLayout());
        this.jProgressBar1.setStringPainted(true);
        this.progressPanel.add((Component)this.jProgressBar1, "South");
        this.getContentPane().add((Component)this.progressPanel, "Center");
        this.startButton.setText("Start");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NBCreateDialog.this.startButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.startButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NBCreateDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.createThread.abortCreate();
        this.jLabel1.setText("Create aborted.");
        this.setVisible(false);
        this.dispose();
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        this.doTileCreation();
    }
}

